<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type");

// Datos de acceso a la cuenta de correo
$imap_server = "zeus.moshipp.com";
$imap_user = "bancolapi@andresplat.com.co";
$imap_password = "altamar599";

// Intentar conexión IMAP
$inbox = imap_open("{".$imap_server.":993/imap/ssl}INBOX", $imap_user, $imap_password);


if (!$inbox) {
    echo json_encode(["status" => "error", "message" => "No se pudo conectar al correo", "error" => imap_last_error()]);
    exit();
}

// Verificar si hay correos en la bandeja
$MC = imap_check($inbox);
if (!$MC || $MC->Nmsgs == 0) {
    echo json_encode(["status" => "error", "message" => "No hay correos en la bandeja"]);
    imap_close($inbox);
    exit();
}

// Obtener los datos enviados por WooCommerce
$input_data = json_decode(file_get_contents("php://input"), true);
if (!isset($input_data['nombre']) || !isset($input_data['monto'])) {
    echo json_encode(["status" => "error", "message" => "Datos inválidos"]);
    exit();
}

function validarNombreFlexible($nombre_usuario, $mensaje) {
    $partes = explode(" ", $nombre_usuario);
    
    if (empty($partes)) return false;

    // Verifica que el primer nombre esté completo en el mensaje
    if (strpos($mensaje, $partes[0]) === false) return false;

    // Para las otras partes del nombre (posibles apellidos)
    for ($i = 1; $i < count($partes); $i++) {
        $parte = $partes[$i];

        // Si está el apellido completo, perfecto
        if (strpos($mensaje, $parte) !== false) continue;

        // Si está la inicial seguida de punto
        $inicial = substr($parte, 0, 1) . ".";
        if (strpos($mensaje, $inicial) === false) return false;
    }

    return true;
}



$nombre = strtoupper(trim($input_data['nombre']));
$monto = number_format($input_data['monto'], 0, '', ',');

// Buscar correos de Bancolombia
// Buscar correos de Bancolombia, usando UIDs
$emails = imap_search($inbox, "ALL", SE_UID);

if (!$emails) {
    echo json_encode(["status" => "error", "message" => "No se encontraron correos de pagos recientes"]);
    imap_close($inbox);
    exit();
}

// Función para obtener el cuerpo del correo usando UIDs
function getEmailBody($inbox, $email_uid) {
    // IMPORTANTE: pasamos la bandera FT_UID para indicar que $email_uid es un UID
    $structure = imap_fetchstructure($inbox, $email_uid, FT_UID);

    if (!$structure) {
        return ["body" => "", "debug" => "imap_fetchstructure devolvió NULL"];
    }

    $body = "";

    // Si el correo tiene múltiples partes
    if (!empty($structure->parts)) {
        foreach ($structure->parts as $index => $part) {
            if ($part->subtype == "PLAIN" || $part->subtype == "HTML") {
                // Pasamos FT_UID al llamar a imap_fetchbody
                $data = imap_fetchbody($inbox, $email_uid, $index + 1, FT_UID);

                if ($part->encoding == 3) { // base64
                    $data = base64_decode($data);
                } elseif ($part->encoding == 4) { // quoted-printable
                    $data = quoted_printable_decode($data);
                }

                $body .= $data;
            }
        }
    } else {
        // Si el correo no tiene múltiples partes, tomamos el cuerpo directamente
        // con la bandera FT_UID
        $body = imap_body($inbox, $email_uid, FT_UID);
    }

    // Depuración: Verificar si el cuerpo está vacío
    if (empty(trim($body))) {
        return ["body" => "", "debug" => "El cuerpo del correo está vacío o mal codificado"];
    }

   // Eliminar los "soft breaks" del quoted-printable
$body = str_replace("=\r\n", "", $body);

// Convertimos todo a mayúsculas y removemos etiquetas HTML
$cleaned = strtoupper(strip_tags($body));

return ["body" => $cleaned, "debug" => "Correo leído correctamente"];

}

// Recorrer los correos en busca del pago
foreach ($emails as $email_uid) {
    $result = getEmailBody($inbox, $email_uid);
    $message_clean = $result["body"];

    // Si el mensaje está vacío, pasamos al siguiente
    if (empty($message_clean)) {
        continue;
    }
   // Verificar si el monto y el nombre están en el mensaje
   if (strpos($message_clean, "$" . $monto) !== false && validarNombreFlexible($nombre, $message_clean)) {

		
		$ch = curl_init("https://bancolapi.digentert.site/eliminar_correo.php");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(["uid" => $email_uid]));
curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/json"]);

$response = curl_exec($ch);
curl_close($ch);

$respuesta_eliminacion = json_decode($response, true);
		
        echo json_encode([
            "status" => "success",
            "message" => "Pago verificado",
            "nombre" => $nombre,
            "monto" => $monto,
            "eid" => $email_uid,
            "debug" => $result["debug"]
        ]);
        imap_close($inbox);
        exit();
    }
}

// Cerrar conexión IMAP
imap_close($inbox);

// Si no se encontró el pago
echo json_encode(["status" => "error", "message" => "Pago no encontrado", "debug" => $result["debug"]]);
?>
